/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.screen.animator;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import lib.toma.animations.engine.screen.animator.Animator;
import lib.toma.animations.engine.screen.animator.AnimatorScreen;
import lib.toma.animations.engine.screen.animator.dialog.DialogScreen;
import lib.toma.animations.engine.screen.animator.dialog.SuggestionResponder;
import lib.toma.animations.engine.screen.animator.widget.ListView;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class AbstractImportScreen
extends Screen {
    protected final AnimatorScreen screen;
    protected ListView<String> paths;
    protected Button confirm;
    protected Button cancel;
    private String selectedPath;

    public AbstractImportScreen(AnimatorScreen screen) {
        super((ITextComponent)new TranslationTextComponent("screen.animator.import"));
        this.screen = screen;
        Animator.get().refreshUserAnimations();
    }

    public final void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        AbstractImportScreen.func_238467_a_((MatrixStack)stack, (int)0, (int)0, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)0x67000000);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    public final boolean func_231046_a_(int code, int scanCode, int modifier) {
        DialogScreen.handleDefaultKeys(code, this.confirm, this.cancel);
        return super.func_231046_a_(code, scanCode, modifier);
    }

    public final boolean func_231177_au__() {
        return false;
    }

    public final boolean func_231178_ax__() {
        return false;
    }

    protected final void func_231160_c_() {
        TextFieldWidget fileFilter = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, 5, 5, this.field_230708_k_ - 10, 20, StringTextComponent.field_240750_d_));
        fileFilter.func_212954_a((Consumer)new SuggestionResponder("Find project", fileFilter, this::fileFilterChanged));
        Animator animator = Animator.get();
        this.paths = (ListView)this.func_230480_a_(new ListView<String>(5, 30, this.field_230708_k_ - 10, this.field_230709_l_ - this.getPathViewHeight(), animator.getPaths()));
        this.paths.setFormatter(Function.identity());
        this.paths.setResponder(this::pathSelected);
        int buttonsWidth = this.field_230708_k_ - 10;
        int buttonWidth = (buttonsWidth - 5) / 2;
        this.placeControlButtons(buttonsWidth, buttonWidth);
        this.updatePathDependents(this.selectedPath);
    }

    protected abstract void placeControlButtons(int var1, int var2);

    protected void fileFilterChanged(String filterValue) {
        this.paths.setFilter(s -> this.acceptPath((String)s, filterValue));
    }

    protected void confirmClicked(Button button) {
        this.showParent();
    }

    protected void cancelClicked(Button button) {
        this.showParent();
    }

    protected void showParent() {
        this.field_230706_i_.func_147108_a((Screen)this.screen);
    }

    protected String getSelectedPath() {
        return this.selectedPath;
    }

    protected int getPathViewHeight() {
        return 60;
    }

    protected void updatePathDependents(@Nullable String path) {
        this.confirm.field_230693_o_ = path != null;
    }

    private boolean acceptPath(String path, String filter) {
        if (filter == null || filter.length() == 0) {
            return true;
        }
        return path.contains(filter);
    }

    private void pathSelected(String path) {
        this.selectedPath = path;
        this.updatePathDependents(path);
    }
}

